import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.response.BindingDetail;
import org.uddi4j.transport.TransportFactory;
import java.util.Vector;

public class UDDIGetBindingDetail1 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");

		BindingDetail bd = proxy.get_bindingDetail("6BCC8130-3AAF-11D5-80DC-002035229C64");

		Vector bdv = bd.getBindingTemplateVector();
		if (bdv.size() == 0) {
			System.out.println("no binding(s) found");
			System.exit(0);
		}

		System.out.println(bdv.size()+" binding(s) found\n");
		for (int i = 0; i < bdv.size(); i++) {
			BindingTemplate bt = (BindingTemplate)bdv.elementAt(i);
			System.out.println(bt.getDefaultDescriptionString());
			System.out.println(bt.getBindingKey());
			System.out.println("\n");
		}
	}
}